/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.i18n;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.behaviour.HumanoidBehaviour;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.IdleGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.MoveAndPlaceItemGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.WorkOnJobGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.pathfinding.GoToLocationGoal;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.Profession;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.wall.Wall;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.constructions.Construction;
import technology.rocketjump.undermount.ui.i18n.I18nKey;
import technology.rocketjump.undermount.ui.i18n.I18nLanguageDictionary;
import technology.rocketjump.undermount.ui.i18n.I18nRepo;
import technology.rocketjump.undermount.ui.i18n.I18nWord;
import technology.rocketjump.undermount.ui.i18n.I18nWordClass;

@Singleton
public class I18nTranslator {
    private final I18nRepo repo;
    private final ProfessionDictionary professionDictionary;

    @Inject
    public I18nTranslator(I18nRepo repo, ProfessionDictionary professionDictionary) {
        this.repo = repo;
        this.professionDictionary = professionDictionary;
    }

    public String getTranslatedString(String i18nKey) {
        I18nWord word = this.repo.getCurrentLanguage().getWord(i18nKey);
        return word.get(I18nWordClass.UNSPECIFIED);
    }

    public String getDescription(Entity entity) {
        switch (entity.getType()) {
            case HUMANOID: {
                return this.getDescription(entity, (HumanoidEntityAttributes)entity.getPhysicalEntityComponent().getAttributes());
            }
            case ITEM: {
                ItemEntityAttributes itemAttributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
                return this.getItemDescription(itemAttributes.getQuantity(), itemAttributes.getMaterial(itemAttributes.getItemType().getPrimaryMaterialType()), itemAttributes.getItemType());
            }
            case PLANT: {
                return this.getDescription(entity, (PlantEntityAttributes)entity.getPhysicalEntityComponent().getAttributes());
            }
            case FURNITURE: {
                return this.getDescription(entity, (FurnitureEntityAttributes)entity.getPhysicalEntityComponent().getAttributes());
            }
        }
        throw new NotImplementedException("Not yet implemented description for entity with type " + (Object)((Object)entity.getType()));
    }

    public String getCurrentGoalDescription(Entity entity, GameContext gameContext) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        if (entity.getType().equals((Object)EntityType.HUMANOID)) {
            HumanoidBehaviour behaviour = (HumanoidBehaviour)entity.getBehaviourComponent();
            HumanoidEntityAttributes attributes = (HumanoidEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
            Goal currentGoal = behaviour.getCurrentGoal();
            if (currentGoal == null || currentGoal instanceof IdleGoal || currentGoal instanceof GoToLocationGoal) {
                return dictionary.getWord("JOB.IDLE.DESCRIPTION").get(I18nWordClass.UNSPECIFIED);
            }
            if (currentGoal instanceof WorkOnJobGoal) {
                WorkOnJobGoal workOnJobGoal = (WorkOnJobGoal)currentGoal;
                if (workOnJobGoal.getAssignedJob() == null) {
                    return dictionary.getWord("JOB.PENDING.DESCRIPTION").get(I18nWordClass.UNSPECIFIED);
                }
                Job assignedJob = workOnJobGoal.getAssignedJob();
                switch (assignedJob.getType()) {
                    case HAULING: {
                        return this.getHaulingJobDescription(assignedJob.getItemAllocation(), attributes);
                    }
                    case CRAFT_AT_WORKSTATION: {
                        return this.getCraftingJobDescription(assignedJob.getRequiredProfession(), attributes);
                    }
                    case MINING: {
                        return this.getMiningJobDescription(assignedJob, attributes, gameContext);
                    }
                    case LOGGING: {
                        return this.getLoggingJobDescription(assignedJob, attributes, gameContext);
                    }
                    case CONSTRUCT_STONE_FURNITURE: 
                    case CONSTRUCT_WOODEN_FURNITURE: {
                        return this.getConstructingFurnitureJobDescription(assignedJob, attributes);
                    }
                    case CLEAR_GROUND: {
                        return this.getClearGroundJobDescription(assignedJob, attributes, gameContext);
                    }
                    case COLLECT_ITEM: {
                        return this.getCollectItemJobDescription(assignedJob, attributes, gameContext);
                    }
                }
                System.err.println("No implementation of description for " + (Object)((Object)assignedJob.getType()) + " job");
                return "";
            }
            if (currentGoal instanceof MoveAndPlaceItemGoal) {
                MoveAndPlaceItemGoal goal = (MoveAndPlaceItemGoal)currentGoal;
                return this.getHaulingJobDescription(goal.getStockpileAllocation(), attributes);
            }
            System.err.println("Not yet implemented description of " + currentGoal);
            return "";
        }
        return "";
    }

    private String getMiningJobDescription(Job assignedJob, HumanoidEntityAttributes attributes, GameContext gameContext) {
        MapTile targetTile = gameContext.getAreaMap().getTile(assignedJob.getJobLocation());
        if (targetTile == null || !targetTile.hasWall()) {
            return "";
        }
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        replacements.put("itemDescription", new I18nWord(this.getWallDescription(targetTile)));
        replacements.put("profession", dictionary.getWord(assignedJob.getRequiredProfession().getI18nKey()));
        return this.applyReplacements(dictionary.getWord("JOB.GENERIC.DESCRIPTION"), replacements, attributes.getGender());
    }

    private String getLoggingJobDescription(Job assignedJob, HumanoidEntityAttributes attributes, GameContext gameContext) {
        MapTile targetTile = gameContext.getAreaMap().getTile(assignedJob.getJobLocation());
        if (targetTile == null || !targetTile.hasTree()) {
            return "";
        }
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        Entity treeInTile = null;
        for (Entity entity : targetTile.getEntities()) {
            if (!entity.getType().equals((Object)EntityType.PLANT)) continue;
            treeInTile = entity;
            break;
        }
        if (treeInTile == null) {
            return "";
        }
        replacements.put("itemDescription", new I18nWord(this.getDescription(treeInTile)));
        replacements.put("profession", dictionary.getWord(assignedJob.getRequiredProfession().getI18nKey()));
        return this.applyReplacements(dictionary.getWord("JOB.GENERIC.DESCRIPTION"), replacements, attributes.getGender());
    }

    private String getClearGroundJobDescription(Job assignedJob, HumanoidEntityAttributes attributes, GameContext gameContext) {
        MapTile targetTile = gameContext.getAreaMap().getTile(assignedJob.getJobLocation());
        if (targetTile == null) {
            return "";
        }
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        Entity plantInTile = null;
        for (Entity entity : targetTile.getEntities()) {
            if (!entity.getType().equals((Object)EntityType.PLANT)) continue;
            plantInTile = entity;
            break;
        }
        if (plantInTile == null) {
            return "";
        }
        replacements.put("plantDescription", new I18nWord(this.getDescription(plantInTile)));
        return this.applyReplacements(dictionary.getWord("JOB.CLEAR_GROUND.DESCRIPTION"), replacements, attributes.getGender());
    }

    public String getConstructingFurnitureJobDescription(Job assignedJob, HumanoidEntityAttributes attributes) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        replacements.put("profession", dictionary.getWord(assignedJob.getRequiredProfession().getI18nKey()));
        return this.applyReplacements(dictionary.getWord("JOB.CONSTRUCT_FURNITURE.DESCRIPTION"), replacements, attributes.getGender());
    }

    public String getWallDescription(MapTile targetTile) {
        if (targetTile == null || !targetTile.hasWall()) {
            return "";
        }
        Wall wall = targetTile.getWall();
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        if (wall.hasOre()) {
            replacements.put("materialType", dictionary.getWord(wall.getOreMaterial().getI18nKey()));
            replacements.put("wallType", dictionary.getWord(wall.getOreType().getI18nKey()));
        } else {
            replacements.put("materialType", dictionary.getWord(wall.getMaterial().getI18nKey()));
            replacements.put("wallType", dictionary.getWord(wall.getWallType().getI18nKey()));
        }
        return this.applyReplacements(dictionary.getWord("WALL.DESCRIPTION"), replacements, Gender.ANY);
    }

    private String getCraftingJobDescription(Profession requiredProfession, HumanoidEntityAttributes attributes) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        return dictionary.getWord(requiredProfession.getI18nKey()).get(I18nWordClass.VERB, attributes.getGender());
    }

    private String getHaulingJobDescription(ItemAllocation haulingAllocation, HumanoidEntityAttributes attributes) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        I18nWord itemDescription = new I18nWord("itemDescription", this.getItemDescription(haulingAllocation.getQuantity(), haulingAllocation.getGameMaterial(), haulingAllocation.getItemType()));
        replacements.put("itemDescription", itemDescription);
        return this.applyReplacements(dictionary.getWord("JOB.HAULING.DESCRIPTION"), replacements, attributes.getGender());
    }

    private String getCollectItemJobDescription(Job assignedJob, HumanoidEntityAttributes attributes, GameContext gameContext) {
        Entity targetItem = gameContext.getEntityStore().getById(assignedJob.getTargetEntityId());
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        I18nWord itemDescription = new I18nWord("itemDescription");
        itemDescription.add(new I18nKey("unused"), this.getDescription(targetItem));
        replacements.put("itemDescription", itemDescription);
        return this.applyReplacements(dictionary.getWord("JOB.HAULING.DESCRIPTION"), replacements, attributes.getGender());
    }

    public String getDescription(Construction construction) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        EntityAttributes attributes = construction.getEntity().getPhysicalEntityComponent().getAttributes();
        if (attributes instanceof FurnitureEntityAttributes) {
            FurnitureEntityAttributes furnitureEntityAttributes = (FurnitureEntityAttributes)attributes;
            replacements.put("materialType", dictionary.getWord(furnitureEntityAttributes.getMaterials().get((Object)furnitureEntityAttributes.getPrimaryMaterialType()).getI18nKey()));
            replacements.put("furnitureType", dictionary.getWord(furnitureEntityAttributes.getFurnitureType().getI18nKey()));
        }
        return this.applyReplacements(dictionary.getWord("CONSTRUCTION.DESCRIPTION"), replacements, Gender.ANY);
    }

    private String getDescription(Entity entity, HumanoidEntityAttributes attributes) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        replacements.put("name", new I18nWord(attributes.getName().toString()));
        replacements.put("race", dictionary.getWord(attributes.getRace().i18nKey));
        ProfessionsComponent professionsComponent = entity.getComponent(ProfessionsComponent.class);
        Profession primaryProfession = professionsComponent.getPrimaryProfession(this.professionDictionary.getDefault());
        replacements.put("profession", dictionary.getWord(primaryProfession.getI18nKey()));
        return this.applyReplacements(dictionary.getWord("HUMANOID.DESCRIPTION"), replacements, attributes.getGender());
    }

    private String getItemDescription(int quantity, GameMaterial material, ItemType itemType) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        replacements.put("quantity", new I18nWord(String.valueOf(quantity)));
        replacements.put("materialType", dictionary.getWord(material.getI18nKey()));
        replacements.put("itemType", dictionary.getWord(itemType.getI18nKey()));
        return this.applyReplacements(dictionary.getWord("ITEM.DESCRIPTION"), replacements, Gender.ANY);
    }

    private String getDescription(Entity entity, PlantEntityAttributes attributes) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        if (attributes.getSpecies().getPlantType().equals((Object)PlantSpeciesType.TREE)) {
            replacements.put("materialType", dictionary.getWord(attributes.getSpecies().getBranchMaterial().getI18nKey()));
            return this.applyReplacements(dictionary.getWord("TREE.DESCRIPTION"), replacements, Gender.ANY);
        }
        return this.applyReplacements(dictionary.getWord("SHRUB.DESCRIPTION"), replacements, Gender.ANY);
    }

    private String getDescription(Entity entity, FurnitureEntityAttributes attributes) {
        I18nLanguageDictionary dictionary = this.repo.getCurrentLanguage();
        HashMap<String, I18nWord> replacements = new HashMap<String, I18nWord>();
        replacements.put("materialType", dictionary.getWord(attributes.getMaterials().get((Object)attributes.getPrimaryMaterialType()).getI18nKey()));
        replacements.put("furnitureType", dictionary.getWord(attributes.getFurnitureType().getI18nKey()));
        return this.applyReplacements(dictionary.getWord("FURNITURE.DESCRIPTION"), replacements, Gender.ANY);
    }

    private String applyReplacements(I18nWord originalWord, Map<String, I18nWord> replacements, Gender gender) {
        String string = originalWord.get(I18nWordClass.UNSPECIFIED, gender);
        String REGEX_START = Pattern.quote("{{");
        String REGEX_END = Pattern.quote("}}");
        Pattern pattern = Pattern.compile(REGEX_START + "([\\w\\\\.]+)" + REGEX_END);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String replacement;
            String token = matcher.group(0);
            if ((token = token.substring(2, token.length() - 2)).equals("quantity_if_multiple")) {
                replacement = this.getQuantity(replacements) > 1 ? this.getQuantity(replacements) + " " : "";
            } else if (token.toUpperCase().equals("BLANK")) {
                replacement = "";
            } else if (token.contains(".")) {
                String[] split = token.split("\\.");
                I18nWord word = replacements.getOrDefault(split[0], new I18nWord(split[0]));
                if (split[1].equals("noun_or_plural")) {
                    replacement = this.getQuantity(replacements) > 1 ? word.get(I18nWordClass.PLURAL, gender) : word.get(I18nWordClass.NOUN, gender);
                } else {
                    I18nWordClass wordClass = I18nWordClass.valueOf(split[1].toUpperCase());
                    replacement = word.get(wordClass, gender);
                }
            } else {
                replacement = replacements.get(token).get(I18nWordClass.UNSPECIFIED, gender);
            }
            if (!token.equals("name")) {
                replacement = replacement.toLowerCase();
            }
            string = string.replace(matcher.group(0), replacement);
        }
        return StringUtils.capitalize(string);
    }

    private int getQuantity(Map<String, I18nWord> replacements) {
        I18nWord quantityWord = replacements.get("quantity");
        if (quantityWord == null) {
            return 0;
        }
        return Integer.valueOf(quantityWord.get(I18nWordClass.UNSPECIFIED));
    }
}

